﻿Imports System.Runtime.Remoting
Imports RemoteCustomer

Public Class Form1

    Private Sub exitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub

    '用于获取对客户端激活类型的引用
    '这类似于 DCOM 样式编程。
    Private mCustomer As Customer

    '希望多个客户端连接到服务器上的
    '同一对象实例时使用
    Private mSCustomer As SingletonCustomer

    Private Sub SetCtlState(ByVal NewState As Boolean)
        '启用创建命令按钮
        Me.cmdCreate.Enabled = NewState

        '禁用其他命令按钮
        Me.cmdGet.Enabled = (Not NewState)
        Me.cmdUpdate.Enabled = (Not NewState)
        Me.cmdUpdateAndGet.Enabled = (Not NewState)
        Me.cmdDebugData.Enabled = (Not NewState)
        Me.cmdRelease.Enabled = (Not NewState)

        '设置单选按钮
        Me.rbClient.Enabled = NewState
        Me.rbSingle.Enabled = NewState

    End Sub

    Private Sub cmdClear_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdClear.Click
        '清除列表框中的所有项
        Me.lstResponses.Items.Clear()
    End Sub

    Private Sub cmdCreate_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdCreate.Click
        Dim txt As String         '在 catch 处理程序中使用
        Try
            Dim objNotCreated As Boolean = False

            If Me.rbClient.Checked = True Then
                '使用客户端激活类型
                '请注意，在这个对 New 的调用中，可以将参数传递给构造函数
                '此类型的对象非常类似于 DCOM 样式对象。
                mCustomer = New Customer(Me.lblDefNameValue.Text, CByte(Me.lblDefAgeValue.Text))
                objNotCreated = (mCustomer Is Nothing)
            Else
                '使用服务器激活类型
                '请注意，在这种情况下不能向构造函数传递值，
                '因为服务器创建该实例，并使其
                '作为单一实例对所有情形可用。只需
                '通过代理获得对运行实例的引用。
                Dim args() As Object = Nothing
                mSCustomer = CType(Activator.CreateInstance(GetType(RemoteCustomer.SingletonCustomer), args), RemoteCustomer.SingletonCustomer)
                mSCustomer.NewClient()
                objNotCreated = (mSCustomer Is Nothing)
            End If

            '更改命令按钮状态
            SetCtlState(objNotCreated)

        Catch exp As RemotingException
            '捕获任意泛型远程处理异常
            txt = "I was unable to access the remote customer object." & vbCrLf & vbCrLf & _
              "Detailed Error Information below:" & vbCrLf & vbCrLf & _
              "  Message: " & exp.Message & vbCrLf & _
              "  Source: " & exp.Source & vbCrLf & vbCrLf & _
              "  Stack Trace:" & vbCrLf & _
              exp.StackTrace()

            MessageBox.Show(txt, "Remoting Exception", MessageBoxButtons.OK, MessageBoxIcon.Stop)

        Catch exp As System.Net.Sockets.SocketException
            '捕获任意套接字异常。
            '这种情况可能发生，是因为我们使用的二进制
            '远程处理接口使用了套接字。
            txt = "I was unable to access the remote customer object." & vbCrLf & _
              "Is it possible the server is not running?" & vbCrLf & vbCrLf & _
              "Detailed Error Information below:" & vbCrLf & vbCrLf & _
              "  Message: " & exp.Message & vbCrLf & _
              "  Source: " & exp.Source & vbCrLf & _
              "  Error Code: " & exp.ErrorCode.ToString() & vbCrLf & _
              "  Native Error Code: " & exp.NativeErrorCode.ToString() & vbCrLf & vbCrLf & _
              "  Stack Trace:" & vbCrLf & _
              exp.StackTrace

            MessageBox.Show(txt, "Socket Exception", MessageBoxButtons.OK, MessageBoxIcon.Stop)

        Catch exp As Exception
            ' 捕获任意泛型异常
            txt = "I was unable to access the remote customer object." & vbCrLf & vbCrLf & _
              "Detailed Error Information below:" & vbCrLf & vbCrLf & _
              "  Message: " & exp.Message & vbCrLf & _
              "  Source: " & exp.Source & vbCrLf & vbCrLf & _
              "  Stack Trace:" & vbCrLf & _
              exp.StackTrace

            MessageBox.Show(txt, "Generic Exception", MessageBoxButtons.OK, MessageBoxIcon.Stop)

        End Try
    End Sub

    Private Sub cmdDebugData_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdDebugData.Click
        '从客户端激活类型获得调试数据
        If ((Not mCustomer Is Nothing) Or (Not mSCustomer Is Nothing)) Then
            Try
                If Me.rbClient.Checked = True Then
                    With Me.lstResponses.Items
                        .Add("Debug data follows:")
                        .Add(String.Format("  Creation Time: {0}", mCustomer.DebugCreationTime.ToString))
                        .Add(String.Format("  Code Base: {0}", mCustomer.DebugCodeBase))
                        .Add(String.Format("  Fully Qualified Name: {0}", mCustomer.DebugFQName))
                        .Add(String.Format("  Remote Host Name: {0}", mCustomer.DebugHostName))
                        .Add("End Debug Data")
                    End With
                Else
                    With Me.lstResponses.Items
                        .Add("Debug data follows:")
                        .Add(String.Format("  Creation Time: {0}", mSCustomer.DebugCreationTime.ToString))
                        .Add(String.Format("  Code Base: {0}", mSCustomer.DebugCodeBase))
                        .Add(String.Format("  Fully Qualified Name: {0}", mSCustomer.DebugFQName))
                        .Add(String.Format("  Remote Host Name: {0}", mSCustomer.DebugHostName))
                        .Add(String.Format("  Number of connected clients: {0}", mSCustomer.Connected.ToString()))
                        .Add("End Debug Data")
                    End With
                End If
            Catch exp As Exception
                ' 捕获任意泛型异常
                ' 更详细的示例请参见 cmdCreate 中的代码。
                Dim txt As String
                txt = "I was unable to access the remote customer object." & vbCrLf & vbCrLf & _
                  "Detailed Error Information below:" & vbCrLf & vbCrLf & _
                  "  Message: " & exp.Message & vbCrLf & _
                  "  Source: " & exp.Source & vbCrLf & vbCrLf & _
                  "  Stack Trace:" & vbCrLf & _
                  exp.StackTrace

                MessageBox.Show(txt, "Generic Exception", MessageBoxButtons.OK, MessageBoxIcon.Stop)

            End Try
        End If
    End Sub

    Private Sub cmdGet_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdGet.Click
        '向服务器请求客户数据
        Try
            If Me.rbClient.Checked = True Then
                Me.lstResponses.Items.Add(mCustomer.GetCustomerInfo())
            Else
                Me.lstResponses.Items.Add(mSCustomer.GetCustomerInfo())
            End If

        Catch exp As Exception
            ' 捕获任意泛型异常
            ' 更详细的示例请参见 cmdCreate 中的代码。
            Dim txt As String
            txt = "I was unable to access the remote customer object." & vbCrLf & vbCrLf & _
              "Detailed Error Information below:" & vbCrLf & vbCrLf & _
              "  Message: " & exp.Message & vbCrLf & _
              "  Source: " & exp.Source & vbCrLf & vbCrLf & _
              "  Stack Trace:" & vbCrLf & _
              exp.StackTrace

            MessageBox.Show(txt, "Generic Exception", MessageBoxButtons.OK, MessageBoxIcon.Stop)

        End Try
    End Sub

    Private Sub cmdUpdate_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdUpdate.Click
        '使用公共属性更新服务器上的值。
        '可能不是最有效的数据更新方式（特别是需要返回值时）。
        '其他示例请参见 cmdUpdateAndGet。
        If ((Not mCustomer Is Nothing) Or (Not mSCustomer Is Nothing)) Then
            Try
                If Me.rbClient.Checked = True Then
                    mCustomer.Name = Me.txtNewName.Text
                    mCustomer.Age = CByte(Me.txtNewAge.Text)
                Else
                    mSCustomer.Name = Me.txtNewName.Text
                    mSCustomer.Age = CByte(Me.txtNewAge.Text)
                End If

                Me.lstResponses.Items.Add("Update using properties successful!")

            Catch exp As Exception
                ' 捕获任意泛型异常
                ' 更详细的示例请参见 cmdCreate 中的代码。
                Dim txt As String
                txt = "I was unable to access the remote customer object." & vbCrLf & vbCrLf & _
                  "Detailed Error Information below:" & vbCrLf & vbCrLf & _
                  "  Message: " & exp.Message & vbCrLf & _
                  "  Source: " & exp.Source & vbCrLf & vbCrLf & _
                  "  Stack Trace:" & vbCrLf & _
                  exp.StackTrace

                MessageBox.Show(txt, "Generic Exception", MessageBoxButtons.OK, MessageBoxIcon.Stop)

            End Try
        End If
    End Sub

    Private Sub cmdUpdateAndGet_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdUpdateAndGet.Click
        '使用接受这两个值的函数更新服务器上的值，
        '并获得客户端激活类型的返回数据。
        'cmdUpdate 中的代码通常采用这种较好的形式，因为
        '可以在较少的往返中完成较多的工作。
        If ((Not mCustomer Is Nothing) Or (Not mSCustomer Is Nothing)) Then
            Try
                If Me.rbClient.Checked = True Then
                    With Me.lstResponses.Items
                        .Add(mCustomer.UpdateCustomerInfo(Me.txtNewName.Text, CByte(Me.txtNewAge.Text)))
                    End With
                Else
                    With Me.lstResponses.Items
                        .Add(mSCustomer.UpdateCustomerInfo(Me.txtNewName.Text, CByte(Me.txtNewAge.Text)))
                    End With
                End If

            Catch exp As Exception
                ' 捕获任意泛型异常
                ' 更详细的示例请参见 cmdCreate 中的代码。
                Dim txt As String
                txt = "I was unable to access the remote customer object." & vbCrLf & vbCrLf & _
                  "Detailed Error Information below:" & vbCrLf & vbCrLf & _
                  "  Message: " & exp.Message & vbCrLf & _
                  "  Source: " & exp.Source & vbCrLf & vbCrLf & _
                  "  Stack Trace:" & vbCrLf & _
                  exp.StackTrace

                MessageBox.Show(txt, "Generic Exception", MessageBoxButtons.OK, MessageBoxIcon.Stop)
            End Try
        End If

    End Sub

    Private Sub cmdRelease_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdRelease.Click
        '释放对服务器对象的引用
        If ((Not mCustomer Is Nothing) Or (Not mSCustomer Is Nothing)) Then
            Dim objReleased As Boolean = False
            If rbClient.Checked = True Then
                '释放代理引用
                mCustomer = Nothing
                objReleased = (mCustomer Is Nothing)
            Else
                '因为该对象公开了该方法，所以应调用该方法。
                '在我们的示例中，该方法没有特别功能，只是
                '减少连接的计数。
                mSCustomer.Dispose()
                mSCustomer = Nothing
                objReleased = (mSCustomer Is Nothing)
            End If

            '更改命令按钮状态
            SetCtlState(objReleased)
        End If
    End Sub

    Private Sub cmdSingleCall_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdSingleCall.Click
        'SingleCall 对象仅在一个方法调用的生命期内生存。
        '如果属性存在，则只有不在
        'SingleCall 模式中使用对象时才能使用属性。
        '此模型非常类似于正确的 MTS/COM+ 组件实现。

        '即使我们不提供参数，也必须传递
        '定义为对象的数组。Nothing 不起作用。
        Dim args() As Object = Nothing
        Dim cust As SingleCallCustomer

        Try
            cust = CType(Activator.CreateInstance(GetType(RemoteCustomer.SingleCallCustomer), args), RemoteCustomer.SingleCallCustomer)
            With Me.lstResponses.Items
                .Add("SingleCall.UpdateCustomerInfo: " & cust.UpdateCustomerInfo(Me.txtNewName.Text, CByte(Me.txtNewAge.Text)))
                .Add("Update Successful!")
            End With
        Catch exp As Exception
            ' 捕获任意泛型异常
            ' 更详细的示例请参见 cmdCreate 中的代码。
            Dim txt As String
            txt = "I was unable to access the remote customer object." & vbCrLf & vbCrLf & _
              "Detailed Error Information below:" & vbCrLf & vbCrLf & _
              "  Message: " & exp.Message & vbCrLf & _
              "  Source: " & exp.Source & vbCrLf & vbCrLf & _
              "  Stack Trace:" & vbCrLf & _
              exp.StackTrace

            MessageBox.Show(txt, "Generic Exception", MessageBoxButtons.OK, MessageBoxIcon.Stop)

        End Try
    End Sub

    Private Sub cmdSingleDebug_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdSingleDebug.Click
        'SingleCall 对象仅在一个方法调用的生命期内生存。
        '每次获取调试数据时，都从
        '对象的新实例获得。

        '即使没有提供参数，也必须传递
        '定义为对象的数组。Nothing 不起作用。
        Dim args() As Object = Nothing
        Dim scCust As SingleCallCustomer

        Try
            scCust = CType(Activator.CreateInstance(GetType(RemoteCustomer.SingleCallCustomer), args), RemoteCustomer.SingleCallCustomer)
            With Me.lstResponses.Items
                .Add("Debug data follows:")
                .Add(String.Format("  Creation Time: {0}", scCust.DebugCreationTime.ToString))
                .Add(String.Format("  Code Base: {0}", scCust.DebugCodeBase))
                .Add(String.Format("  Fully Qualified Name: {0}", scCust.DebugFQName))
                .Add(String.Format("  Remote Host Name: {0}", scCust.DebugHostName))
                '注意创建时间的不同！
                .Add(String.Format("  Creation Time: {0}", scCust.DebugCreationTime.ToString))
                .Add("End Debug Data")
            End With

        Catch exp As Exception
            ' 捕获任意泛型异常
            ' 更详细的示例请参见 cmdCreate 中的代码。
            Dim txt As String
            txt = "I was unable to access the remote customer object." & vbCrLf & vbCrLf & _
              "Detailed Error Information below:" & vbCrLf & vbCrLf & _
              "  Message: " & exp.Message & vbCrLf & _
              "  Source: " & exp.Source & vbCrLf & vbCrLf & _
              "  Stack Trace:" & vbCrLf & _
              exp.StackTrace

            MessageBox.Show(txt, "Generic Exception", MessageBoxButtons.OK, MessageBoxIcon.Stop)

        End Try

    End Sub

    Private Sub frmMain_Closed(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Closed
        '释放仍然占用的任意对象
        If Not mCustomer Is Nothing Then
            mCustomer = Nothing
        End If
    End Sub

    Private Sub frmMain_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Load
        '在应用程序配置文件 (client.exe.config) 中读取。此文件包含
        '客户端远程处理基础结构的远程处理配置信息。
        Try
            '假定文件和此 exe 位于同一目录中。
            RemotingConfiguration.Configure("client.exe.config", False)

        Catch exp As Exception
            ' 捕获任意泛型异常
            Dim txt As String
            txt = "I was unable to load the file config.xml." & vbCrLf & _
              "Please make sure it is located in the same directory as this exe " & _
              " and that it is in the correct format." & vbCrLf & _
              "Please see the Help, About box for the location of this exe." & vbCrLf & vbCrLf & _
              "Detailed Error Information below:" & vbCrLf & vbCrLf & _
              "  Message: " & exp.Message & vbCrLf & _
              "  Source: " & exp.Source & vbCrLf & vbCrLf & _
              "  Stack Trace:" & vbCrLf & _
              exp.StackTrace

            MessageBox.Show(txt, "Generic Exception", MessageBoxButtons.OK, MessageBoxIcon.Stop)

            '关闭创建命令按钮
            Me.cmdCreate.Enabled = False
        End Try

    End Sub

    Private Sub txtNewAge_Validating(ByVal sender As System.Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles txtNewAge.Validating
        '检查以确保仅输入数值，
        '并检查数据类型是否为字节
        Try
            Dim d As Byte = CByte(Me.txtNewAge.Text)
        Catch exp As Exception
            Dim txt As String
            txt = "The value you entered, '{0}', for the Customer's New Age is incorrect." & vbCrLf & _
            "Please enter a value in the range of 0 to 255." & vbCrLf & _
            "The value will be reset to 0 by default."

            MessageBox.Show(String.Format(txt, Me.txtNewAge.Text), Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation)

            '将默认值设置为 0 并取消字段退出。
            Me.txtNewAge.Text = "0"
            e.Cancel = True
        End Try
    End Sub

End Class
